/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.result;

import filenet.vw.api.VWDataField;
import filenet.vw.api.VWExposedFieldDefinition;
import filenet.vw.api.VWLogElement;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWQueueElement;
import filenet.vw.api.VWRosterElement;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWWorkObject;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.result.IVWAdminFieldChangeEventListener;
import filenet.vw.toolkit.admin.result.VWAdminElementInLogTableModel;
import filenet.vw.toolkit.admin.result.VWAdminElementInQueueTableModel;
import filenet.vw.toolkit.admin.result.VWAdminElementInRosterTableModel;
import filenet.vw.toolkit.admin.result.VWAdminElementTableData;
import filenet.vw.toolkit.admin.result.VWAdminElementTableModel;
import filenet.vw.toolkit.admin.result.VWAdminFieldChangeEvent;
import filenet.vw.toolkit.admin.result.VWAdminFieldsTableData;
import filenet.vw.toolkit.admin.result.VWAdminResultPane;
import filenet.vw.toolkit.admin.result.VWAdminStatisticsTableModel;
import filenet.vw.toolkit.admin.result.VWAdminWFByElementInRosterTableModel;
import filenet.vw.toolkit.admin.result.VWAdminWFByWOInRosterTableModel;
import filenet.vw.toolkit.admin.result.VWAdminWFObjByWOInProcQueueTableModel;
import filenet.vw.toolkit.admin.result.VWAdminWFObjByWOInRosterTableModel;
import filenet.vw.toolkit.admin.result.VWAdminWFObjByWOInSysQueueTableModel;
import filenet.vw.toolkit.admin.result.VWAdminWOInQueueTableModel;
import filenet.vw.toolkit.admin.result.VWAdminWOInRosterTableModel;
import filenet.vw.toolkit.admin.result.VWAdminWOTableModel;
import filenet.vw.toolkit.admin.result.VWAdminWorkObjectTableData;
import filenet.vw.toolkit.admin.result.images.VWImageLoader;
import filenet.vw.toolkit.admin.result.resources.VWResource;
import filenet.vw.toolkit.admin.search.VWAdminPerformSearchEvent;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.table.VWParticipantItem;
import filenet.vw.toolkit.utils.table.VWSortedListModel;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;

public abstract class VWAdminResultTableModelBase
extends AbstractTableModel
implements IVWAdminFieldChangeEventListener {
    protected static final int VW_NONE = -1;
    protected static final int VW_ROSTER = 0;
    protected static final int VW_QUEUE = 1;
    protected static final int VW_LOG = 2;
    protected VWExposedFieldDefinition[] m_vwFieldDefinitions = null;
    protected VWAdminResultPane m_resultsPane = null;
    protected Vector m_headers = new Vector();
    protected Vector m_rowCache = new Vector();
    protected Vector m_elementCache = new Vector();
    protected Vector m_objectCache = new Vector();
    protected String[] m_selectedColumnsFromQuery = null;
    protected Vector m_availableColumns = new Vector();
    protected Vector m_selectedColumns = new Vector();
    protected Vector m_availableFields = new Vector();
    protected VWParticipantItem[] m_selectedUsers = null;
    protected int m_maxReturned = 50;
    protected boolean m_bAutowrap = false;
    protected boolean m_hasNext = false;
    protected int m_setNum = 0;
    protected int m_startIndex = 0;
    protected VWSession m_vwSession = null;
    protected VWParticipant m_logonUser = null;
    protected String m_queryIndexName = null;
    protected Object[] m_queryMinIndexValue = null;
    protected Object[] m_queryMaxIndexValue = null;
    protected int m_queryFlags = -1;
    protected String m_queryFilter = null;
    protected Object[] m_querySubstitutionVars = null;
    protected int m_queryFetchType = -1;
    protected static final int COL_ROW_INDEX = 0;
    protected static int COL_EXCEPTION_INDICATOR = -1;
    protected static int COL_DIRTY = -1;
    protected static int COL_LOCK_STATUS = -1;
    protected static int COL_QUEUE_NAME = -1;
    protected static int COL_TRACKER = -1;
    protected static int COL_DUE_STATUS = -1;

    public abstract void getNextBatch() throws Exception;

    public abstract Class getColumnClass(int var1);

    public abstract Object getValueAt(int var1, int var2);

    public abstract void setValueAt(Object var1, int var2, int var3);

    protected abstract Object getObjectAt(int var1, int var2);

    protected abstract Object getObjectAt(int var1);

    protected abstract void retrieveRowData();

    protected abstract void retrieveRowData(int var1);

    protected abstract void refreshTable();

    protected abstract int fetchQueryCount() throws Exception;

    public VWAdminResultTableModelBase(VWAdminResultPane resultsPane, VWAdminPerformSearchEvent event) {
        this.m_vwSession = resultsPane.getSession();
        this.m_logonUser = resultsPane.getLogonUser();
        this.m_bAutowrap = resultsPane.getAutowrap();
        this.m_maxReturned = event.getMaxReturned();
        this.m_selectedColumnsFromQuery = event.getColumnNames();
        this.m_queryFilter = event.getFilterString();
        this.m_queryIndexName = event.getIndexName();
        this.m_queryMinIndexValue = event.getMinValues();
        this.m_queryMaxIndexValue = event.getMaxValues();
        this.m_queryFlags = event.getIndexFlags();
        this.m_resultsPane = resultsPane;
    }

    public void fieldChanged(VWAdminFieldChangeEvent event, int rowIndex) {
        if (event == null) {
            return;
        }
        Object source = event.getSource();
        if (source == null) {
            return;
        }
        Object value = null;
        try {
            if (event.isFieldType() && source instanceof VWAdminFieldsTableData) {
                VWAdminFieldsTableData dataField = (VWAdminFieldsTableData)source;
                String fieldName = dataField.getName();
                VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)this.m_objectCache.elementAt(rowIndex);
                VWWorkObject wob = woData.getWob();
                if (woData.getLockedStatus() != 1) {
                    return;
                }
                if (!wob.hasFieldName(fieldName)) {
                    return;
                }
                value = wob.getFieldValue(fieldName);
                if (value != null || dataField.getType() == 512) {
                    dataField.writeDataFieldsToWorkObject(wob);
                    woData.setDirty(true);
                    Vector rowData = (Vector)this.m_rowCache.elementAt(rowIndex);
                    if (rowData != null) {
                        ImageIcon aValue = VWImageLoader.createImageIcon("pencil_col.gif");
                        aValue.setDescription(VWResource.s_workItemIsModified);
                        rowData.setElementAt(aValue, COL_DIRTY);
                        this.fireTableRowsUpdated(rowIndex, rowIndex);
                        this.m_resultsPane.fireMenuOptionsUpdate();
                    }
                }
                if (!(this instanceof VWAdminWFByWOInRosterTableModel) && !(this instanceof VWAdminWFByElementInRosterTableModel)) {
                    return;
                }
                Vector v_children = woData.getChildren();
                for (int i = 0; i < v_children.size(); ++i) {
                    VWAdminWorkObjectTableData childWoData = (VWAdminWorkObjectTableData)v_children.elementAt(i);
                    VWWorkObject childWob = childWoData.getWob();
                    if (childWob == null || childWoData.getLockedStatus() != 1 || !childWob.hasFieldName(fieldName) || (value = childWob.getFieldValue(fieldName)) == null) continue;
                    dataField.writeDataFieldsToWorkObject(childWob);
                    childWoData.setDirty(true);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public int getRowCount() {
        return this.m_rowCache.size();
    }

    public int getColumnCount() {
        return this.m_headers.size();
    }

    public String getColumnName(int index) {
        if (index >= this.m_headers.size()) {
            return VWResource.s_emptyString;
        }
        return (String)this.m_headers.elementAt(index);
    }

    public int getSetNum() {
        return this.m_setNum;
    }

    public void getSearchCount() {
        int count = 0;
        try {
            count = this.fetchQueryCount();
        }
        catch (Exception ex) {
            count = -1;
            VWDebug.logException(ex);
            JOptionPane.showMessageDialog(this.m_resultsPane.getParentFrame(), ex.getLocalizedMessage(), VWResource.s_errorMessage, 0);
        }
        if (count >= 0) {
            String text = new String(VWResource.s_searchCountMsg + count);
            JOptionPane.showMessageDialog(this.m_resultsPane.getParentFrame(), text, VWResource.s_searchCount, 1);
        }
    }

    protected void refreshAllRows() {
        try {
            this.retrieveRowData();
            this.fireTableDataChanged();
            if (this instanceof VWAdminWOTableModel) {
                this.m_resultsPane.resetControls();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            JOptionPane.showMessageDialog(this.m_resultsPane.getParentFrame(), ex.getLocalizedMessage(), VWResource.s_errorMessage, 0);
        }
    }

    protected void refreshSelectedRows(int[] selectedRows) {
        try {
            for (int i = 0; i < selectedRows.length; ++i) {
                this.retrieveRowData(selectedRows[i]);
                this.fireTableRowsUpdated(selectedRows[i], selectedRows[i]);
            }
            if (this instanceof VWAdminWOTableModel) {
                this.m_resultsPane.resetControls();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            JOptionPane.showMessageDialog(this.m_resultsPane.getParentFrame(), ex.getLocalizedMessage(), VWResource.s_errorMessage, 0);
        }
    }

    protected Vector getAvailableColumns() {
        return this.m_availableColumns;
    }

    protected Vector getSelectedColumns() {
        return this.m_selectedColumns;
    }

    protected void setSelectedColumns(String[] newSelectedColumns) {
        try {
            this.m_selectedColumns.removeAllElements();
            if (newSelectedColumns != null) {
                for (int i = 0; i < newSelectedColumns.length; ++i) {
                    this.m_selectedColumns.addElement(newSelectedColumns[i]);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void setQueryFlags(int flag) {
        this.m_queryFlags = flag;
    }

    protected void setQueryFetchType(int flag) {
        this.m_queryFetchType = flag;
    }

    protected void setQueryIndexName(String name) {
        this.m_queryIndexName = name;
    }

    protected void setQueryMinIndexValue(Object[] minValues) {
        this.m_queryMinIndexValue = minValues;
    }

    protected void setQueryMaxIndexValue(Object[] maxValues) {
        this.m_queryMaxIndexValue = maxValues;
    }

    protected void setQueryFilter(String filter) {
        this.m_queryFilter = filter;
    }

    protected boolean hasNext() {
        return this.m_hasNext;
    }

    protected void setHasNext(boolean isMore) {
        this.m_hasNext = isMore;
    }

    protected boolean isInVector(String name, Vector aVector) {
        try {
            if (aVector.size() == 0) {
                return false;
            }
            String aName = null;
            for (int i = 0; i < aVector.size(); ++i) {
                aName = (String)aVector.elementAt(i);
                if (VWStringUtils.compare(name, aName) != 0) continue;
                return true;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return false;
    }

    protected boolean isInStringArray(String name, String[] anArray) {
        try {
            if (anArray == null) {
                return false;
            }
            String aName = null;
            for (int i = 0; i < anArray.length; ++i) {
                aName = anArray[i];
                if (VWStringUtils.compare(name, anArray[i]) != 0) continue;
                return true;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return false;
    }

    protected boolean isInExposedFieldDefinitions(String name, VWExposedFieldDefinition[] vwFieldDefinitions) {
        try {
            if (vwFieldDefinitions == null) {
                return false;
            }
            for (int i = 0; i < vwFieldDefinitions.length; ++i) {
                if (VWStringUtils.compare(name, vwFieldDefinitions[i].getName()) != 0) continue;
                return true;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return false;
    }

    protected VWDataField getDataField(String name, Vector availableFields) {
        try {
            if (availableFields == null) {
                return null;
            }
            for (int i = 0; i < availableFields.size(); ++i) {
                VWDataField vwDataField = (VWDataField)availableFields.elementAt(i);
                if (VWStringUtils.compare(name, vwDataField.getName()) != 0) continue;
                return vwDataField;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    protected VWDataField findDataFieldInWO(VWWorkObject curWorkObject, String fieldName) {
        try {
            if (!curWorkObject.hasFieldName(fieldName)) {
                return null;
            }
            VWDataField[] vwDataFields = curWorkObject.getDataFields(767, 3);
            for (int i = 0; i < vwDataFields.length; ++i) {
                if (VWStringUtils.compare(fieldName, vwDataFields[i].getName()) != 0) continue;
                return vwDataFields[i];
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    protected VWDataField findDataFieldInElement(VWRosterElement curElement, String fieldName) {
        try {
            if (!curElement.hasFieldName(fieldName)) {
                return null;
            }
            VWDataField[] vwDataFields = curElement.getDataFields();
            for (int i = 0; i < vwDataFields.length; ++i) {
                if (VWStringUtils.compare(fieldName, vwDataFields[i].getName()) != 0) continue;
                return vwDataFields[i];
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    protected VWDataField findDataFieldInElement(VWQueueElement curElement, String fieldName) {
        try {
            if (!curElement.hasFieldName(fieldName)) {
                return null;
            }
            VWDataField[] vwDataFields = curElement.getDataFields();
            for (int i = 0; i < vwDataFields.length; ++i) {
                if (VWStringUtils.compare(fieldName, vwDataFields[i].getName()) != 0) continue;
                return vwDataFields[i];
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    protected VWDataField findDataFieldInElement(VWLogElement curElement, String fieldName) {
        try {
            if (!curElement.hasField(fieldName)) {
                return null;
            }
            VWDataField[] vwDataFields = curElement.getDataFields();
            for (int i = 0; i < vwDataFields.length; ++i) {
                if (VWStringUtils.compare(fieldName, vwDataFields[i].getName()) != 0) continue;
                return vwDataFields[i];
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    protected void resetFilterStringForWorkflow() {
        String s_filter = "F_WobNum = F_WorkFlowNumber";
        String copyFilter = this.m_queryFilter;
        this.m_queryFilter = copyFilter == null ? s_filter : (VWStringUtils.compare(copyFilter, "") == 0 ? s_filter : "(" + copyFilter + ")" + " AND " + "(" + s_filter + ")");
    }

    protected void resetFilterStringForUsers() {
        if (this.m_selectedUsers == null || this.m_selectedUsers.length == 0) {
            return;
        }
        try {
            boolean bFound = false;
            for (int i = 0; i < this.m_selectedUsers.length; ++i) {
                if (this.m_selectedUsers[i].getType() != 3) continue;
                bFound = true;
                break;
            }
            if (bFound) {
                return;
            }
            String s_filter = null;
            for (int i = 0; i < this.m_selectedUsers.length; ++i) {
                int id = this.m_vwSession.convertUserNameToId(this.m_selectedUsers[i].getVWParticipant().getParticipantName());
                String boundUserExp = "F_BoundUser=" + id;
                s_filter = i == 0 ? boundUserExp : s_filter + " OR " + boundUserExp;
            }
            String copyFilter = this.m_queryFilter;
            this.m_queryFilter = copyFilter == null ? s_filter : (VWStringUtils.compare(copyFilter, "") == 0 ? s_filter : "(" + copyFilter + ")" + " AND " + "(" + s_filter + ")");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void resetWorkObjects(boolean forceReset, boolean lock, boolean override) {
        VWWorkObject curWorkObject = null;
        try {
            for (int i = 0; i < this.m_objectCache.size(); ++i) {
                VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)this.m_objectCache.elementAt(i);
                curWorkObject = woData.getWob();
                if (!forceReset && curWorkObject.getIsAltered()) continue;
                curWorkObject.doRefresh(lock, override);
                woData.resetData();
                this.retrieveRowData(i);
                this.fireTableRowsUpdated(i, i);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void relockWorkObjects() {
        VWWorkObject[] woArray = null;
        VWWorkObject curWorkObject = null;
        Vector<VWWorkObject> woVector = new Vector<VWWorkObject>();
        try {
            int i;
            for (i = 0; i < this.m_objectCache.size(); ++i) {
                VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)this.m_objectCache.elementAt(i);
                curWorkObject = woData.getWob();
                int lockStatus = woData.getLockedStatus();
                if (lockStatus == 1) {
                    woVector.addElement(curWorkObject);
                }
                Vector v_children = woData.getChildren();
                for (int j = 0; j < v_children.size(); ++j) {
                    VWAdminWorkObjectTableData childWoData = (VWAdminWorkObjectTableData)v_children.elementAt(j);
                    VWWorkObject childWob = childWoData.getWob();
                    if (childWob == null || childWoData.getLockedStatus() != 1) continue;
                    woVector.addElement(childWob);
                }
            }
            if (woVector.size() != 0) {
                woArray = new VWWorkObject[woVector.size()];
                for (i = 0; i < woVector.size(); ++i) {
                    woArray[i] = (VWWorkObject)woVector.elementAt(i);
                }
                if (this instanceof VWAdminWOInRosterTableModel) {
                    for (i = 0; i < woArray.length; ++i) {
                        try {
                            woArray[i].doLock(true);
                            continue;
                        }
                        catch (Exception ex) {
                            VWDebug.logException(ex);
                        }
                    }
                } else {
                    VWWorkObject.doLockMany(woArray, true);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void retrieveRowDataForWorkObject() {
        VWWorkObject curWorkObject = null;
        Vector<Object> rowData = null;
        String fieldName = null;
        Object fieldValue = null;
        VWAdminFieldsTableData dataField = null;
        VWDataField vwDataField = null;
        try {
            if (this.m_rowCache != null) {
                this.m_rowCache.removeAllElements();
            }
            int vwType = this instanceof VWAdminWOInRosterTableModel ? 0 : (this instanceof VWAdminWOInQueueTableModel ? 1 : -1);
            for (int i = 0; i < this.m_objectCache.size(); ++i) {
                boolean isDirty;
                VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)this.m_objectCache.elementAt(i);
                curWorkObject = woData.getWob();
                rowData = new Vector<Object>();
                rowData.addElement(new Integer(woData.getDisplayRowIndex()));
                if (!(this instanceof VWAdminWFByWOInRosterTableModel)) {
                    ImageIcon exceptionElement = null;
                    String exceptionStr = curWorkObject.getLastErrorNumber();
                    if (exceptionStr != null && VWStringUtils.compare(exceptionStr, "0") != 0) {
                        exceptionElement = VWImageLoader.createImageIcon("error.gif");
                        exceptionElement.setDescription(VWResource.s_workItemHasException);
                    }
                    rowData.addElement(exceptionElement);
                    ImageIcon iconStatus = null;
                    switch (curWorkObject.getOverdue()) {
                        case 1: {
                            iconStatus = VWImageLoader.createImageIcon("reminder.gif");
                            iconStatus.setDescription(VWResource.s_workItemhasReminder);
                            rowData.addElement(iconStatus);
                            break;
                        }
                        case 2: {
                            iconStatus = VWImageLoader.createImageIcon("bwoverdue.gif");
                            iconStatus.setDescription(VWResource.s_workItemIsOverdue);
                            rowData.addElement(iconStatus);
                            break;
                        }
                        case 3: {
                            iconStatus = VWImageLoader.createImageIcon("completed.gif");
                            iconStatus.setDescription(VWResource.s_workItemIsCompleted);
                            rowData.addElement(iconStatus);
                            break;
                        }
                        default: {
                            iconStatus = VWImageLoader.createImageIcon("blank.gif");
                            iconStatus.setDescription(null);
                            rowData.addElement(iconStatus);
                        }
                    }
                }
                if (this instanceof VWAdminWFObjByWOInRosterTableModel || this instanceof VWAdminWFObjByWOInProcQueueTableModel || this instanceof VWAdminWFObjByWOInSysQueueTableModel) {
                    if (curWorkObject.getIsTracker()) {
                        ImageIcon icon = VWImageLoader.createImageIcon("tracker.gif");
                        icon.setDescription(VWResource.s_workItemIsTracker);
                        rowData.addElement(icon);
                    } else {
                        rowData.addElement(null);
                    }
                }
                if (isDirty = woData.isDirty()) {
                    ImageIcon icon = VWImageLoader.createImageIcon("pencil_col.gif");
                    icon.setDescription(VWResource.s_workItemIsModified);
                    rowData.addElement(icon);
                } else {
                    rowData.addElement(null);
                }
                int lockStatus = woData.getLockedStatus();
                ImageIcon lockStatusIcon = null;
                if (lockStatus == 3) {
                    lockStatusIcon = VWImageLoader.createImageIcon("unlocked.gif");
                    lockStatusIcon.setDescription(VWResource.s_workItemUnlocked);
                    rowData.addElement(lockStatusIcon);
                } else if (lockStatus == 0) {
                    lockStatusIcon = VWImageLoader.createImageIcon("lockedbysystem.gif");
                    lockStatusIcon.setDescription(VWResource.s_workItemLockedBySystem);
                    rowData.addElement(lockStatusIcon);
                } else if (lockStatus == 2) {
                    lockStatusIcon = VWImageLoader.createImageIcon("lockedbyother.gif");
                    lockStatusIcon.setDescription(VWResource.s_workItemLockedByOtherUser);
                    rowData.addElement(lockStatusIcon);
                } else if (lockStatus == 1) {
                    lockStatusIcon = VWImageLoader.createImageIcon("lockedbyuser.gif");
                    lockStatusIcon.setDescription(VWResource.s_workItemLockedByCurrentUser);
                    rowData.addElement(lockStatusIcon);
                } else {
                    rowData.addElement(null);
                }
                if (this instanceof VWAdminWFObjByWOInRosterTableModel) {
                    rowData.addElement(curWorkObject.getCurrentQueueName());
                }
                for (int col = this.getStartIndex(); col < this.m_headers.size(); ++col) {
                    dataField = null;
                    fieldName = (String)this.m_headers.elementAt(col);
                    vwDataField = this.findDataFieldInWO(curWorkObject, fieldName);
                    if (vwDataField != null) {
                        dataField = new VWAdminFieldsTableData(vwDataField, curWorkObject, this.m_vwSession, vwType);
                        dataField.addFieldChangeEventListener(this);
                    } else {
                        dataField = null;
                    }
                    rowData.addElement(dataField);
                }
                this.m_rowCache.addElement(rowData);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void retrieveRowDataForWorkObject(int rowIndex) {
        VWWorkObject curWorkObject = null;
        Vector<Object> rowData = null;
        String fieldName = null;
        Object fieldValue = null;
        VWAdminFieldsTableData dataField = null;
        VWDataField vwDataField = null;
        try {
            boolean isDirty;
            int vwType = this instanceof VWAdminWOInRosterTableModel ? 0 : (this instanceof VWAdminWOInQueueTableModel ? 1 : -1);
            VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)this.m_objectCache.elementAt(rowIndex);
            curWorkObject = woData.getWob();
            rowData = new Vector<Object>();
            rowData.addElement(new Integer(woData.getDisplayRowIndex()));
            if (!(this instanceof VWAdminWFByWOInRosterTableModel)) {
                ImageIcon exceptionElement = null;
                String exceptionStr = curWorkObject.getLastErrorNumber();
                if (exceptionStr != null && VWStringUtils.compare(exceptionStr, "0") != 0) {
                    exceptionElement = VWImageLoader.createImageIcon("error.gif");
                    exceptionElement.setDescription(VWResource.s_workItemHasException);
                }
                rowData.addElement(exceptionElement);
                ImageIcon iconStatus = null;
                switch (curWorkObject.getOverdue()) {
                    case 1: {
                        iconStatus = VWImageLoader.createImageIcon("reminder.gif");
                        iconStatus.setDescription(VWResource.s_workItemhasReminder);
                        rowData.addElement(iconStatus);
                        break;
                    }
                    case 2: {
                        iconStatus = VWImageLoader.createImageIcon("bwoverdue.gif");
                        iconStatus.setDescription(VWResource.s_workItemIsOverdue);
                        rowData.addElement(iconStatus);
                        break;
                    }
                    case 3: {
                        iconStatus = VWImageLoader.createImageIcon("completed.gif");
                        iconStatus.setDescription(VWResource.s_workItemIsCompleted);
                        rowData.addElement(iconStatus);
                        break;
                    }
                    default: {
                        iconStatus = VWImageLoader.createImageIcon("blank.gif");
                        iconStatus.setDescription(null);
                        rowData.addElement(iconStatus);
                    }
                }
            }
            if (this instanceof VWAdminWFObjByWOInRosterTableModel || this instanceof VWAdminWFObjByWOInProcQueueTableModel || this instanceof VWAdminWFObjByWOInSysQueueTableModel) {
                if (curWorkObject.getIsTracker()) {
                    ImageIcon icon = VWImageLoader.createImageIcon("tracker.gif");
                    icon.setDescription(VWResource.s_workItemIsTracker);
                    rowData.addElement(icon);
                } else {
                    rowData.addElement(null);
                }
            }
            if (isDirty = woData.isDirty()) {
                ImageIcon icon = VWImageLoader.createImageIcon("pencil_col.gif");
                icon.setDescription(VWResource.s_workItemIsModified);
                rowData.addElement(icon);
            } else {
                rowData.addElement(null);
            }
            int lockStatus = woData.getLockedStatus();
            ImageIcon lockStatusIcon = null;
            if (lockStatus == 3) {
                lockStatusIcon = VWImageLoader.createImageIcon("unlocked.gif");
                lockStatusIcon.setDescription(VWResource.s_workItemUnlocked);
                rowData.addElement(lockStatusIcon);
            } else if (lockStatus == 0) {
                lockStatusIcon = VWImageLoader.createImageIcon("lockedbysystem.gif");
                lockStatusIcon.setDescription(VWResource.s_workItemLockedBySystem);
                rowData.addElement(lockStatusIcon);
            } else if (lockStatus == 2) {
                lockStatusIcon = VWImageLoader.createImageIcon("lockedbyother.gif");
                lockStatusIcon.setDescription(VWResource.s_workItemLockedByOtherUser);
                rowData.addElement(lockStatusIcon);
            } else if (lockStatus == 1) {
                lockStatusIcon = VWImageLoader.createImageIcon("lockedbyuser.gif");
                lockStatusIcon.setDescription(VWResource.s_workItemLockedByCurrentUser);
                rowData.addElement(lockStatusIcon);
            } else {
                rowData.addElement(null);
            }
            if (this instanceof VWAdminWFObjByWOInRosterTableModel) {
                rowData.addElement(curWorkObject.getCurrentQueueName());
            }
            for (int col = this.getStartIndex(); col < this.m_headers.size(); ++col) {
                dataField = null;
                fieldName = (String)this.m_headers.elementAt(col);
                vwDataField = this.findDataFieldInWO(curWorkObject, fieldName);
                if (vwDataField != null) {
                    dataField = new VWAdminFieldsTableData(vwDataField, curWorkObject, this.m_vwSession, vwType);
                    dataField.addFieldChangeEventListener(this);
                } else {
                    dataField = null;
                }
                rowData.addElement(dataField);
            }
            this.m_rowCache.setElementAt(rowData, rowIndex);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void removeWorkObjectsOutOfTable() {
        VWAdminWorkObjectTableData woData;
        int i = 0;
        block0: do {
            for (i = 0; i < this.m_objectCache.size(); ++i) {
                woData = (VWAdminWorkObjectTableData)this.m_objectCache.elementAt(i);
                if (!woData.isToBeRemoved()) continue;
                this.m_objectCache.removeElementAt(i);
                continue block0;
            }
        } while (i < this.m_objectCache.size());
        for (i = 0; i < this.m_objectCache.size(); ++i) {
            woData = (VWAdminWorkObjectTableData)this.m_objectCache.elementAt(i);
            woData.setRowIndex(i);
            woData.setDisplayRowIndex(i + 1);
        }
    }

    protected boolean validateIndex() {
        if (this.m_queryIndexName != null && this.m_queryIndexName.equals("F_WobNum")) {
            if (this.m_queryMinIndexValue == null || this.m_queryMaxIndexValue == null || this.m_queryMinIndexValue[0] == null || this.m_queryMaxIndexValue[0] == null) {
                return false;
            }
            try {
                String minValue = (String)this.m_queryMinIndexValue[0];
                String maxValue = (String)this.m_queryMaxIndexValue[0];
                if (VWStringUtils.compare(minValue, maxValue) != 0) {
                    return false;
                }
            }
            catch (Exception ex) {
                return false;
            }
        }
        return true;
    }

    protected void sortAndAddToList(Vector unsortedList, Vector finalList) {
        int i;
        if (unsortedList == null || finalList == null) {
            return;
        }
        VWSortedListModel listModel = new VWSortedListModel();
        for (i = 0; i < unsortedList.size(); ++i) {
            listModel.addElement(unsortedList.elementAt(i));
        }
        listModel.sort();
        for (i = 0; i < listModel.size(); ++i) {
            finalList.addElement(listModel.elementAt(i));
        }
    }

    protected boolean isFieldNameInWO(int rowIndex, int columnIndex) {
        try {
            VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)this.getObjectAt(rowIndex);
            if (woData == null) {
                return false;
            }
            VWWorkObject wob = woData.getWob();
            if (wob == null) {
                return false;
            }
            String colName = this.getColumnName(columnIndex);
            return wob.hasFieldName(colName);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return false;
        }
    }

    protected boolean isFieldNameInVWObject(int rowIndex, int columnIndex) {
        try {
            if (this instanceof VWAdminWOTableModel) {
                return this.isFieldNameInWO(rowIndex, columnIndex);
            }
            if (this instanceof VWAdminElementTableModel) {
                String colName = this.getColumnName(columnIndex);
                VWAdminElementTableData elementData = (VWAdminElementTableData)this.getObjectAt(rowIndex);
                if (elementData == null) {
                    return false;
                }
                if (this instanceof VWAdminElementInLogTableModel) {
                    VWLogElement element = (VWLogElement)elementData.getElement();
                    if (element == null) {
                        return false;
                    }
                    return element.hasField(colName);
                }
                if (this instanceof VWAdminElementInRosterTableModel) {
                    VWRosterElement element = (VWRosterElement)elementData.getElement();
                    if (element == null) {
                        return false;
                    }
                    return element.hasFieldName(colName);
                }
                if (this instanceof VWAdminElementInQueueTableModel) {
                    VWQueueElement element = (VWQueueElement)elementData.getElement();
                    if (element == null) {
                        return false;
                    }
                    return element.hasFieldName(colName);
                }
                return false;
            }
            return this instanceof VWAdminStatisticsTableModel;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return false;
        }
    }

    protected boolean isFieldEditable(int rowIndex, int columnIndex) {
        try {
            VWAdminFieldsTableData fieldData;
            if (!(this instanceof VWAdminWOTableModel)) {
                return false;
            }
            if (rowIndex > this.getRowCount() - 1) {
                return false;
            }
            if (!this.isValidColumnToEdit(columnIndex)) {
                return false;
            }
            VWAdminWorkObjectTableData woData = (VWAdminWorkObjectTableData)this.m_objectCache.elementAt(rowIndex);
            VWWorkObject curWorkObject = woData.getWob();
            if (!curWorkObject.hasFieldName(this.getColumnName(columnIndex))) {
                return false;
            }
            Vector rowData = (Vector)this.m_rowCache.elementAt(rowIndex);
            if (rowData != null && !this.isValidFieldDataToEdit(fieldData = (VWAdminFieldsTableData)rowData.elementAt(columnIndex))) {
                return false;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return true;
    }

    protected boolean isValidColumnToEdit(int columnIndex) {
        if (columnIndex > this.getColumnCount() - 1) {
            return false;
        }
        if (columnIndex == 0 || columnIndex == COL_EXCEPTION_INDICATOR || columnIndex == COL_DUE_STATUS || columnIndex == COL_DIRTY || columnIndex == COL_LOCK_STATUS) {
            return false;
        }
        return !(this instanceof VWAdminWFObjByWOInRosterTableModel ? columnIndex == COL_QUEUE_NAME || columnIndex == COL_TRACKER : (this instanceof VWAdminWFObjByWOInProcQueueTableModel || this instanceof VWAdminWFObjByWOInSysQueueTableModel) && columnIndex == COL_TRACKER);
    }

    protected boolean isValidFieldDataToEdit(VWAdminFieldsTableData fieldData) {
        try {
            if (fieldData == null) {
                return false;
            }
            if (!fieldData.isWritableField()) {
                return false;
            }
            int type = fieldData.getType();
            if (type == 32 || type == 64) {
                return false;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return true;
    }

    protected int getStartIndex() {
        return this.m_startIndex;
    }

    protected void initColumnsOrder() {
        if (this instanceof VWAdminWOTableModel) {
            if (this instanceof VWAdminWFByWOInRosterTableModel) {
                COL_DIRTY = 1;
                COL_LOCK_STATUS = 2;
            } else {
                COL_EXCEPTION_INDICATOR = 1;
                COL_DUE_STATUS = 2;
                if (this instanceof VWAdminWFObjByWOInRosterTableModel) {
                    COL_TRACKER = 3;
                    COL_DIRTY = 4;
                    COL_LOCK_STATUS = 5;
                    COL_QUEUE_NAME = 6;
                } else if (this instanceof VWAdminWFObjByWOInProcQueueTableModel || this instanceof VWAdminWFObjByWOInSysQueueTableModel) {
                    COL_TRACKER = 3;
                    COL_DIRTY = 4;
                    COL_LOCK_STATUS = 5;
                } else {
                    COL_DIRTY = 3;
                    COL_LOCK_STATUS = 4;
                }
            }
        } else if (this instanceof VWAdminElementInQueueTableModel && this.isInExposedFieldDefinitions("F_Overdue", this.m_vwFieldDefinitions)) {
            COL_DUE_STATUS = 1;
        }
    }

    protected void removeReferences() {
        if (this.m_objectCache != null) {
            this.m_objectCache.removeAllElements();
        }
        if (this.m_rowCache != null) {
            this.m_rowCache.removeAllElements();
        }
    }
}

